<!-- About Section -->
<div class="py-16 bg-gray-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <!-- Left Column - Text Content -->
            <div>
                <h2 class="text-4xl font-bold text-gray-900 mb-4">Klinik Zen Jogja</h2>
                <div class="w-16 h-1 bg-amber-300 mb-4"></div>
                <h3 class="text-xl font-medium text-gray-800 mb-6 italic">Perawatan Kulit & Kecantikan Medis</h3>
                <p class="text-gray-700 text-lg leading-relaxed mb-8">
                    Klinik Zen Jogja tidak hanya fokus pada tindakan bedah plastik, tetapi juga menghadirkan berbagai perawatan kulit dan kecantikan medis yang dirancang untuk meningkatkan kesehatan kulit, memperbaiki tekstur, serta menjaga penampilan tetap segar dan alami.
                </p>
                <button class="bg-amber-300 text-white px-8 py-3 rounded-none font-semibold hover:bg-amber-400 transition duration-150">
                    Selengkapnya
                </button>
            </div>

            <!-- Right Column - Image Carousel -->
            <div class="relative">
                <div class="relative overflow-hidden rounded-none">
                    <!-- Main Image -->
                    <div class="w-full h-80 bg-cover bg-center bg-no-repeat rounded-none" style="background-image: url('{{ asset('images/banner/bannehome.png') }}');">
                        <!-- Navigation Arrows -->
                        <button class="absolute left-4 top-1/2 transform -translate-y-1/2 w-10 h-10 bg-white bg-opacity-80 rounded-full flex items-center justify-center hover:bg-opacity-100 transition duration-150">
                            <svg class="w-5 h-5 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                            </svg>
                        </button>
                        <button class="absolute right-4 top-1/2 transform -translate-y-1/2 w-10 h-10 bg-white bg-opacity-80 rounded-full flex items-center justify-center hover:bg-opacity-100 transition duration-150">
                            <svg class="w-5 h-5 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                            </svg>
                        </button>
                    </div>
                    
                    <!-- Pagination Dots -->
                    <div class="flex justify-center mt-4 space-x-2">
                        <div class="w-3 h-3 bg-gray-800 rounded-full"></div>
                        <div class="w-3 h-3 bg-gray-300 rounded-full"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
